﻿/* Skript zur Demonstration von Zeichenfunktionen
 * Als Benutzer SCOTT ausführen
 */
 
-- Verwendung der Funktion INSTR
select instr('C:\my_folder\my_files\foo.txt', '\', 4, 2) position
  from dual;
  
select instr('C:\my_folder\my_files\foo.txt', '\', -1) position
  from dual;
  
-- Verwendung der Funktion LENGTH
select length('Törömtömtöm') zeichen, 
       lengthb('Törömtömtöm') byte
  from dual;
  
-- Verwendung der Funktion SOUNDEX
select ename, job, sal
  from emp
 where soundex(ename) in (soundex('SMYTHE'), soundex('MÜLLER'));
 
-- Verwendung der Funktion LOWER, UPPER, INITCAP
select lower(ename), upper(ename), initcap(ename)
  from emp
 where lower(ename) = lower('Miller');
 
-- Verwendung der Funktion LPAD und RPAD
select rpad(ename, 15, '.') ename,
       lpad(sal, 10, '.') sal
  from emp;

-- Verwendung der Funktion TRIM
select trim(both '.' from '...SMITH...') text
  from dual;
  
select trim(leading '.' from '...SMITH...') text
  from dual;
  
select trim(trailing '.' from '...SMITH...') text
  from dual;
  
select '#' || trim('   SMITH   ') || '#' text
  from dual;
  
-- Verwendung der Funktion LTRIM und RTRIM
select rtrim(ltrim('<Das ist ein Element/>', '<'), '/>') text
  from dual;
  
-- Verwendung der Funktion REPLACE
select replace('Katalog 2011: ICD_2011', '2011', '2012') text
  from dual;
  
select replace('SALESMAN', 'MAN') text
  from dual;
  
-- Verwendung der Funktion SUBSTR
select substr('Das ist ein Text', 9, 3) text
  from dual;
  
select substr ('Das ist ein Text', 9) text
  from dual;
  
-- Komplettes Beispiel für Textfunktionen
select substr('Müller, Peter', instr('Müller, Peter', ',') + 2) vorname,
       substr('Müller, Peter', 1, instr('Müller, Peter', ',') - 1) nachname
  from dual;

-- Verwendung der Funktion TRNASLATE
select translate('+49 (171) 123-456-789', 
         '0123456789+- ()', '0123456789') rufnummer
  from dual;

select translate('+49 (171) 123-456-789', 
         '0123456789', '0123456789') rufnummer
  from dual;
  
-- Der "Q"-Operator
select 'select ''SMITH'' from dual' ausgabe
  from dual;
 
-- Fehler, sobald ein Zeichen fehlt
/*select 'select 'SMITH'' from dual' ausgabe
  from dual;
*/
-- Mit Q-Operator
select q'[select 'SMITH' from dual]' ausgabe
  from dual;
  
-- Die Kombination mit Spalten schlägt aber fehl
select q'[select ' || ename || ' from dual]' ausgabe
  from emp
 where rownum = 1;
 
-- Q-Operator mit Spaltenwert
select q'[select ']' || ename || q'[' from dual]' ausgabe
  from emp
 where rownum = 1;
 
-- Alternative Lösung mit Hilfe der replace-Funktion
select replace(
         q'[select '#ENAME#' from dual]', 
         '#ENAME#', ename) ausgabe
  from emp
 where rownum = 1;
